<table style="width:100%; color:#000000 !important;">
	<tbody>
		<tr>
			<td>

				<style>
					@page { size: A4 portrait; margin: 12mm; }
					* { box-sizing: border-box; }
					.a4-wrap { width: 100%; font-family: Arial, Helvetica, sans-serif; }
					.a4-row { width: 100%; display: table; table-layout: fixed; }
					.a4-col { display: table-cell; vertical-align: top; }
					.a4-50 { width: 50%; }
					.a4-60 { width: 60%; }
					.a4-40 { width: 40%; }
					.a4-right { text-align: right; }
					.a4-muted { color: #666; }
					.a4-h1 { font-size: 18px; font-weight: 800; margin: 0; }
					.a4-h2 { font-size: 16px; font-weight: 800; margin: 0 0 10px; letter-spacing: .5px; }
					.a4-mt-12 { margin-top: 12px; }
					.a4-mt-18 { margin-top: 18px; }
					.a4-mt-24 { margin-top: 24px; }
					.a4-band {
						background: #b9e3d6 !important;
						border: 1px solid #9fd3c3;
						padding: 18px 18px 16px;
						-webkit-print-color-adjust: exact;
						print-color-adjust: exact;
					}
					.a4-kv { width: 100%; border-collapse: collapse; }
                    .a4-kv td { padding: 2px 0; vertical-align: top; }
                    
                    .a4-kv td.key{
                      width: 52%;
                      font-weight: 700;
                      text-align: right;     /* <-- puts "Invoice No:" near the value (right side) */
                      padding-right: 10px;   /* <-- spacing */
                      white-space: nowrap;
                    }
                    .a4-kv td.val{
                      width: 48%;
                      text-align: right;
                      white-space: nowrap;
                    }

					.a4-divider { border-top: 2px solid #7f7f7f; margin: 18px 0; }
					.a4-thanks { font-size: 24px; font-weight: 600; color: #666; line-height: 1.1; }
					.a4-avoid { page-break-inside: avoid !important; }
					
					.a4-items{
                      border-collapse: collapse !important;
                      border-spacing: 0 !important;
                    }
                    .a4-items.table-bordered,
                    .a4-items.table-bordered > thead > tr > th,
                    .a4-items.table-bordered > tbody > tr > td{
                      border: 1px solid #d0d0d0 !important; /* single consistent line */
                    }
                    
                    /* items table */
                    .a4-items{
                      border-collapse: collapse !important;
                      border-spacing: 0 !important;
                      border: 1px solid #d0d0d0 !important; /* outer border stays */
                    }
                    
                    /* normal grid */
                    .a4-items th,
                    .a4-items td{
                      border: 1px solid #d0d0d0 !important;
                    }
                    
                    /* EMPTY filler rows: remove grid lines */
                    .a4-items tr.a4-empty-row td{
                      border: 0 !important;              
                      height: 18px;                    
                    }
                    
                    .a4-qr-box{
                      position: relative;
                      min-height: 160px; /* increase if you want it lower */
                    }
                    .a4-qr-bottom{
                      position: absolute;
                      right: 0;
                      bottom: 2px;
                    }
				</style>

				<div class="a4-wrap">

					{{-- Header band: business left, logo right --}}
					<div class="a4-band">
						<div class="a4-row">
							<div class="a4-col a4-60">
								@php
                                  $display_name_first = '';
                                  if (!empty($receipt_details->display_name)) {
                                      $parts = explode(',', $receipt_details->display_name);
                                      $display_name_first = trim($parts[0] ?? $receipt_details->display_name);
                                  }
                                @endphp
                                
                                @if(!empty($display_name_first))
                                  <div class="a4-h1">{{ $display_name_first }}</div>
                                @endif

								<div class="a4-muted a4-mt-12" style="line-height: 1.5;">
									@if(!empty($receipt_details->address))
										{!! $receipt_details->address !!}<br>
									@endif
									@if(!empty($receipt_details->contact))
										{!! $receipt_details->contact !!}<br>
									@endif
									@if(!empty($receipt_details->website))
										{{ $receipt_details->website }}<br>
									@endif
									@if(!empty($receipt_details->tax_info1))
										{{ $receipt_details->tax_label1 }} {{ $receipt_details->tax_info1 }}<br>
									@endif
									@if(!empty($receipt_details->tax_info2))
										{{ $receipt_details->tax_label2 }} {{ $receipt_details->tax_info2 }}<br>
									@endif
									@if(!empty($receipt_details->location_custom_fields))
										{{ $receipt_details->location_custom_fields }}
									@endif
								</div>

								@if(!empty($receipt_details->invoice_heading))
									<div class="a4-mt-18" style="font-weight: 800; font-size: 22px;">
										{!! $receipt_details->invoice_heading !!}
									</div>
								@endif
							</div>

							<div class="a4-col a4-40 a4-right">
                              @if(empty($receipt_details->letter_head))
                                @if(!empty($receipt_details->logo))
                                  <img
                                    src="{{$receipt_details->logo}}"
                                    style="
                                      max-height: 80px;      /* smaller logo */
                                      width: auto;
                                      float: right;         /* push to the extreme right */
                                      display: block;
                                    "
                                  >
                                @endif
                              @endif
                            </div>
						</div>
					</div>

					@if(!empty($receipt_details->letter_head))
						<div class="a4-mt-12">
							<img style="width: 100%; margin-bottom: 10px;" src="{{$receipt_details->letter_head}}">
						</div>
					@endif

					{{-- Bill To (left) + Invoice Details (right) --}}
					<div class="a4-row a4-mt-24">
						<div class="a4-col a4-50">
							<div class="a4-h2">{{ __('BILL TO') }}</div>

							<div style="line-height: 1.5;">
								@if(!empty($receipt_details->customer_label))
									<strong>{{ $receipt_details->customer_label }}</strong><br>
								@endif

								@if(!empty($receipt_details->customer_info))
									{!! $receipt_details->customer_info !!}
								@endif

								@if(!empty($receipt_details->client_id_label))
									<br><strong>{{ $receipt_details->client_id_label }}</strong> {{ $receipt_details->client_id }}
								@endif

								@if(!empty($receipt_details->customer_tax_label))
									<br><strong>{{ $receipt_details->customer_tax_label }}</strong> {{ $receipt_details->customer_tax_number }}
								@endif

								@if(!empty($receipt_details->customer_custom_fields))
									<br>{!! $receipt_details->customer_custom_fields !!}
								@endif

								@if(!empty($receipt_details->sales_person_label))
									<br><strong>{{ $receipt_details->sales_person_label }}</strong> {{ $receipt_details->sales_person }}
								@endif

								@if(!empty($receipt_details->commission_agent_label))
									<br><strong>{{ $receipt_details->commission_agent_label }}</strong> {{ $receipt_details->commission_agent }}
								@endif

								@if(!empty($receipt_details->customer_rp_label))
									<br><strong>{{ $receipt_details->customer_rp_label }}</strong> {{ $receipt_details->customer_total_rp }}
								@endif

								@if(!empty($receipt_details->types_of_service))
									<br>
									<strong>{!! $receipt_details->types_of_service_label !!}:</strong> {{$receipt_details->types_of_service}}
									@if(!empty($receipt_details->types_of_service_custom_fields))
										<br>
										@foreach($receipt_details->types_of_service_custom_fields as $key => $value)
											<strong>{{$key}}:</strong> {{$value}}@if(!$loop->last), @endif
										@endforeach
									@endif
								@endif
							</div>
						</div>

						<div class="a4-col a4-50">
							<div class="a4-h2 a4-right">{{ __('INVOICE DETAILS') }}</div>

							<table class="a4-kv">
								@if(!empty($receipt_details->invoice_no_prefix) || !empty($receipt_details->invoice_no))
									<tr>
                                      <td class="key">
                                        {!! !empty($receipt_details->invoice_no_prefix) ? $receipt_details->invoice_no_prefix : __('Invoice No:') !!}
                                      </td>
                                      <td class="val">
                                        {{$receipt_details->invoice_no}}
                                      </td>
                                    </tr>
								@endif

								@if(!empty($receipt_details->date_label))
									<tr>
										<td class="key a4-right">{{$receipt_details->date_label}}</td>
										<td class="val">{{$receipt_details->invoice_date}}</td>
									</tr>
								@endif

								@if(!empty($receipt_details->due_date_label))
									<tr>
										<td class="key a4-right">{{$receipt_details->due_date_label}}</td>
										<td class="val">{{$receipt_details->due_date ?? ''}}</td>
									</tr>
								@endif

								@if(!empty($receipt_details->sell_custom_field_1_value))
									<tr>
										<td class="key a4-right">{{$receipt_details->sell_custom_field_1_label}}</td>
										<td class="val">{{$receipt_details->sell_custom_field_1_value}}</td>
									</tr>
								@endif
								@if(!empty($receipt_details->sell_custom_field_2_value))
									<tr>
										<td class="key a4-right">{{$receipt_details->sell_custom_field_2_label}}</td>
										<td class="val">{{$receipt_details->sell_custom_field_2_value}}</td>
									</tr>
								@endif
								@if(!empty($receipt_details->sell_custom_field_3_value))
									<tr>
										<td class="key a4-right">{{$receipt_details->sell_custom_field_3_label}}</td>
										<td class="val">{{$receipt_details->sell_custom_field_3_value}}</td>
									</tr>
								@endif
								@if(!empty($receipt_details->sell_custom_field_4_value))
									<tr>
										<td class="key a4-right">{{$receipt_details->sell_custom_field_4_label}}</td>
										<td class="val">{{$receipt_details->sell_custom_field_4_value}}</td>
									</tr>
								@endif

								@if(!empty($receipt_details->total_due) && !empty($receipt_details->total_due_label))
									<tr>
										<td class="key a4-right">{!! $receipt_details->total_due_label !!}</td>
										<td class="val">{{$receipt_details->total_due}}</td>
									</tr>
								@endif

								@if(!empty($receipt_details->total_previous_due))
									<tr>
										<td class="key a4-right">{!! $receipt_details->total_previous_due_label !!}</td>
										<td class="val">{{$receipt_details->total_previous_due}}</td>
									</tr>
								@endif

								@if(!empty($receipt_details->all_due))
									<tr>
										<td class="key a4-right">{!! $receipt_details->all_bal_label !!}</td>
										<td class="val">{{$receipt_details->all_due}}</td>
									</tr>
								@endif

								@if(!empty($receipt_details->total_paid))
									<tr>
										<td class="key a4-right">{!! $receipt_details->total_paid_label !!}</td>
										<td class="val">{{$receipt_details->total_paid}}</td>
									</tr>
								@endif
							</table>

							@if(!empty($receipt_details->table_label) || !empty($receipt_details->table))
								<div class="a4-mt-12 a4-right">
									@if(!empty($receipt_details->table_label))
										{!! $receipt_details->table_label !!}
									@endif
									{{$receipt_details->table}}
								</div>
							@endif

							@if(!empty($receipt_details->service_staff_label) || !empty($receipt_details->service_staff))
								<div class="a4-right">
									@if(!empty($receipt_details->service_staff_label))
										{!! $receipt_details->service_staff_label !!}
									@endif
									{{$receipt_details->service_staff}}
								</div>
							@endif
						</div>
					</div>

					{{-- Shipping custom fields (kept, just placed after header blocks) --}}
					@if(!empty($receipt_details->shipping_custom_field_1_label) || !empty($receipt_details->shipping_custom_field_2_label))
						<div class="a4-row a4-mt-12">
							<div class="a4-col a4-50">
								@if(!empty($receipt_details->shipping_custom_field_1_label))
									<strong>{!!$receipt_details->shipping_custom_field_1_label!!} :</strong> {!!$receipt_details->shipping_custom_field_1_value ?? ''!!}
								@endif
							</div>
							<div class="a4-col a4-50 a4-right">
								@if(!empty($receipt_details->shipping_custom_field_2_label))
									<strong>{!!$receipt_details->shipping_custom_field_2_label!!} :</strong> {!!$receipt_details->shipping_custom_field_2_value ?? ''!!}
								@endif
							</div>
						</div>
					@endif

					@if(!empty($receipt_details->shipping_custom_field_3_label) || !empty($receipt_details->shipping_custom_field_4_label))
						<div class="a4-row a4-mt-12">
							<div class="a4-col a4-50">
								@if(!empty($receipt_details->shipping_custom_field_3_label))
									<strong>{!!$receipt_details->shipping_custom_field_3_label!!} :</strong> {!!$receipt_details->shipping_custom_field_3_value ?? ''!!}
								@endif
							</div>
							<div class="a4-col a4-50 a4-right">
								@if(!empty($receipt_details->shipping_custom_field_4_label))
									<strong>{!!$receipt_details->shipping_custom_field_4_label!!} :</strong> {!!$receipt_details->shipping_custom_field_4_value ?? ''!!}
								@endif
							</div>
						</div>
					@endif

					@if(!empty($receipt_details->shipping_custom_field_5_label))
						<div class="a4-row a4-mt-12">
							<div class="a4-col a4-50">
								<strong>{!!$receipt_details->shipping_custom_field_5_label!!} :</strong> {!!$receipt_details->shipping_custom_field_5_value ?? ''!!}
							</div>
						</div>
					@endif

					@if(!empty($receipt_details->sale_orders_invoice_no) || !empty($receipt_details->sale_orders_invoice_date))
						<div class="a4-row a4-mt-12">
							<div class="a4-col a4-50">
								<strong>@lang('restaurant.order_no'):</strong> {!!$receipt_details->sale_orders_invoice_no ?? ''!!}
							</div>
							<div class="a4-col a4-50 a4-right">
								<strong>@lang('lang_v1.order_dates'):</strong> {!!$receipt_details->sale_orders_invoice_date ?? ''!!}
							</div>
						</div>
					@endif

					<div class="a4-row a4-mt-12">
						@includeIf('sale_pos.receipts.partial.common_repair_invoice')
					</div>

					{{-- Items table (unchanged content, just positioned like A4) --}}
					<div class="a4-mt-24">
						<table class="table table-bordered table-no-top-cell-border table-slim mb-12 a4-items" style="width:100%;">
							{{-- ====== THEAD ====== --}}
                            @php
                              $merge_cat_into_product = ($receipt_details->show_cat_code == 1);
                              $product_colspan = $merge_cat_into_product ? 2 : 1;
                            
                              $p_width = 40;
                              if ($merge_cat_into_product) {
                                $p_width += 10; // take the removed cat-code width
                              }
                              if(!empty($receipt_details->item_discount_label)) $p_width -= 10;
                              if(!empty($receipt_details->discounted_unit_price_label)) $p_width -= 5;
                            @endphp
                            
                            <thead>
                              <tr style="background-color:#357ca5 !important;color:#fff !important;font-size:20px !important"
                                  class="table-no-side-cell-border table-no-top-cell-border text-center">
                                <td style="background-color:#357ca5 !important;color:#fff !important;width:5% !important">#</td>
                            
                                <td colspan="{{ $product_colspan }}"
                                    style="background-color:#357ca5 !important;color:#fff !important;width:{{ $p_width }}% !important">
                                  {{$receipt_details->table_product_label}}
                                </td>
                            
                                <td style="background-color:#357ca5 !important;color:#fff !important;width:15% !important;">
                                  {{$receipt_details->table_qty_label}}
                                </td>
                                <td style="background-color:#357ca5 !important;color:#fff !important;width:15% !important;">
                                  {{$receipt_details->table_unit_price_label}}
                                </td>
                            
                                @if(!empty($receipt_details->discounted_unit_price_label))
                                  <td style="background-color:#357ca5 !important;color:#fff !important;width:10% !important;">
                                    {{$receipt_details->discounted_unit_price_label}}
                                  </td>
                                @endif
                            
                                @if(!empty($receipt_details->item_discount_label))
                                  <td style="background-color:#357ca5 !important;color:#fff !important;width:10% !important;">
                                    {{$receipt_details->item_discount_label}}
                                  </td>
                                @endif
                            
                                <td style="background-color:#357ca5 !important;color:#fff !important;width:10% !important;">
                                  {{$receipt_details->table_subtotal_label}}
                                </td>
                              </tr>
                            </thead>
                            
                            {{-- ====== TBODY (main lines) ====== --}}
                            <tbody>
                            @foreach($receipt_details->lines as $line)
                              <tr>
                                <td class="text-center">{{$loop->iteration}}</td>
                            
                                <td colspan="{{ $product_colspan }}">
                                  @if(!empty($line['image']))
                                    <img src="{{$line['image']}}" alt="Image" width="50" style="float:left;margin-right:8px;">
                                  @endif
                            
                                  {{$line['name']}} {{$line['product_variation']}} {{$line['variation']}}
                                  @if(!empty($line['sub_sku'])), {{$line['sub_sku']}} @endif
                                  @if(!empty($line['brand'])), {{$line['brand']}} @endif
                                  @if(!empty($line['product_custom_fields'])), {{$line['product_custom_fields']}} @endif
                            
                                  {{-- If you still want cat code text, append it here instead of separate column --}}
                                  @if($merge_cat_into_product && !empty($line['cat_code']))
                                    , {{$line['cat_code']}}
                                  @endif
                            
                                  @if(!empty($line['product_description']))
                                    <small>{!!$line['product_description']!!}</small>
                                  @endif
                            
                                  @if(!empty($line['sell_line_note']))
                                    <br><small>{!!$line['sell_line_note']!!}</small>
                                  @endif
                            
                                  @if(!empty($line['lot_number']))<br> {{$line['lot_number_label']}}: {{$line['lot_number']}} @endif
                                  @if(!empty($line['product_expiry'])), {{$line['product_expiry_label']}}: {{$line['product_expiry']}} @endif
                                </td>
                            
                                <td class="text-right">{{$line['quantity']}} {{$line['units']}}</td>
                                <td class="text-right">{{$line['unit_price_before_discount']}}</td>
                            
                                @if(!empty($receipt_details->discounted_unit_price_label))
                                  <td class="text-right">{{$line['unit_price_inc_tax']}}</td>
                                @endif
                            
                                @if(!empty($receipt_details->item_discount_label))
                                  <td class="text-right">
                                    {{$line['total_line_discount'] ?? '0.00'}}
                                    @if(!empty($line['line_discount_percent'])) ({{$line['line_discount_percent']}}%) @endif
                                  </td>
                                @endif
                            
                                <td class="text-right">{{$line['line_total_exc_tax']}}</td>
                              </tr>
                            
                              {{-- ====== modifiers (also merge) ====== --}}
                              @if(!empty($line['modifiers']))
                                @foreach($line['modifiers'] as $modifier)
                                  <tr>
                                    <td class="text-center">&nbsp;</td>
                            
                                    <td colspan="{{ $product_colspan }}">
                                      {{$modifier['name']}} {{$modifier['variation']}}
                                      @if(!empty($modifier['sub_sku'])), {{$modifier['sub_sku']}} @endif
                                      @if(!empty($modifier['sell_line_note']))({!!$modifier['sell_line_note']!!}) @endif
                            
                                      @if($merge_cat_into_product && !empty($modifier['cat_code']))
                                        , {{$modifier['cat_code']}}
                                      @endif
                                    </td>
                            
                                    <td class="text-right">{{$modifier['quantity']}} {{$modifier['units']}}</td>
                                    <td class="text-right">{{$modifier['unit_price_exc_tax']}}</td>
                            
                                    @if(!empty($receipt_details->discounted_unit_price_label))
                                      <td class="text-right">{{$modifier['unit_price_exc_tax']}}</td>
                                    @endif
                                    @if(!empty($receipt_details->item_discount_label))
                                      <td class="text-right">0.00</td>
                                    @endif
                            
                                    <td class="text-right">{{$modifier['line_total']}}</td>
                                  </tr>
                                @endforeach
                              @endif
                            @endforeach
                            
                            {{-- ====== empty rows: IMPORTANT: no extra cat col anymore ====== --}}
                            @php
                              $rowCount = count($receipt_details->lines ?? []);
                              $minRows = 7;
                            
                              $cols = 1 /* # */ + 1 /* Product (merged) */ + 1 /* Qty */ + 1 /* Unit Price */ + 1 /* Subtotal */;
                              if(!empty($receipt_details->discounted_unit_price_label)) $cols++;
                              if(!empty($receipt_details->item_discount_label)) $cols++;
                            @endphp
                            
                            @for ($r = $rowCount; $r < $minRows; $r++)
                              <tr class="a4-empty-row">
                                @for ($c = 0; $c < $cols; $c++)
                                  <td>&nbsp;</td>
                                @endfor
                              </tr>
                            @endfor
                            </tbody>
						</table>
					</div>

					{{-- Thank you (left) + Totals (right) --}}
					<div class="a4-row a4-mt-24 a4-avoid">
						<div class="a4-col a4-50">
							<div class="a4-thanks">
								Thank you for your<br>business!
							</div>

							@if(!empty($receipt_details->additional_notes))
								<div class="a4-mt-18">{!! nl2br($receipt_details->additional_notes) !!}</div>
							@endif
						</div>

						<div class="a4-col a4-50">
							<table class="table-no-side-cell-border table-no-top-cell-border width-100 table-slim">
								<tbody>
									@if(!empty($receipt_details->total_quantity_label))
										<tr>
											<td style="width:50%">{!! $receipt_details->total_quantity_label !!}</td>
											<td class="text-right">{{$receipt_details->total_quantity}}</td>
										</tr>
									@endif

									@if(!empty($receipt_details->total_items_label))
										<tr>
											<td style="width:50%">{!! $receipt_details->total_items_label !!}</td>
											<td class="text-right">{{$receipt_details->total_items}}</td>
										</tr>
									@endif

									<tr>
										<td style="width:50%">{!! $receipt_details->subtotal_label !!}</td>
										<td class="text-right">{{$receipt_details->subtotal_exc_tax}}</td>
									</tr>

									@if(!empty($receipt_details->shipping_charges))
										<tr>
											<td style="width:50%">{!! $receipt_details->shipping_charges_label !!}</td>
											<td class="text-right">{{$receipt_details->shipping_charges}}</td>
										</tr>
									@endif

									@if(!empty($receipt_details->packing_charge))
										<tr>
											<td style="width:50%">{!! $receipt_details->packing_charge_label !!}</td>
											<td class="text-right">{{$receipt_details->packing_charge}}</td>
										</tr>
									@endif

									@if(!empty($receipt_details->taxes))
										@foreach($receipt_details->taxes as $k => $v)
											<tr>
												<td>{{$k}}</td>
												<td class="text-right">(+) {{$v}}</td>
											</tr>
										@endforeach
									@endif

									@if(!empty($receipt_details->discount))
										<tr>
											<td>{!! $receipt_details->discount_label !!}</td>
											<td class="text-right">(-) {{$receipt_details->discount}}</td>
										</tr>
									@endif

									@if(!empty($receipt_details->total_line_discount))
										<tr>
											<td>{!! $receipt_details->line_discount_label !!}</td>
											<td class="text-right">(-) {{$receipt_details->total_line_discount}}</td>
										</tr>
									@endif

									@if(!empty($receipt_details->additional_expenses))
										@foreach($receipt_details->additional_expenses as $key => $val)
											<tr>
												<td>{{$key}}:</td>
												<td class="text-right">(+) {{$val}}</td>
											</tr>
										@endforeach
									@endif

									@if(!empty($receipt_details->reward_point_label))
										<tr>
											<td>{!! $receipt_details->reward_point_label !!}</td>
											<td class="text-right">(-) {{$receipt_details->reward_point_amount}}</td>
										</tr>
									@endif

									@if(!empty($receipt_details->group_tax_details))
										@foreach($receipt_details->group_tax_details as $key => $value)
											<tr>
												<td>{!! $key !!}</td>
												<td class="text-right">(+) {{$value}}</td>
											</tr>
										@endforeach
									@else
										@if(!empty($receipt_details->tax))
											<tr>
												<td>{!! $receipt_details->tax_label !!}</td>
												<td class="text-right">(+) {{$receipt_details->tax}}</td>
											</tr>
										@endif
									@endif

									@if($receipt_details->round_off_amount > 0)
										<tr>
											<td>{!! $receipt_details->round_off_label !!}</td>
											<td class="text-right">{{$receipt_details->round_off}}</td>
										</tr>
									@endif

									<tr>
										<th style="background-color: #357ca5 !important; color: white !important" class="font-23 padding-10">
											{!! $receipt_details->total_label !!}
										</th>
										<td class="text-right font-23 padding-10" style="background-color: #357ca5 !important; color: white !important">
											{{$receipt_details->total}}
										</td>
									</tr>

									@if(!empty($receipt_details->total_in_words))
										<tr>
											<td colspan="2" class="text-right">
												<small>({{$receipt_details->total_in_words}})</small>
											</td>
										</tr>
									@endif
								</tbody>
							</table>
						</div>
					</div>

					{{-- Tax summary (kept) --}}
					<div class="a4-mt-18">
						@if(empty($receipt_details->hide_price) && !empty($receipt_details->tax_summary_label))
							@if(!empty($receipt_details->taxes))
								<table class="table table-slim table-bordered" style="width:100%;">
									<tr>
										<th colspan="2" class="text-center">{{$receipt_details->tax_summary_label}}</th>
									</tr>
									@foreach($receipt_details->taxes as $key => $val)
										<tr>
											<td class="text-center"><b>{{$key}}</b></td>
											<td class="text-center">{{$val}}</td>
										</tr>
									@endforeach
								</table>
							@endif
						@endif
					</div>

					<div class="a4-divider"></div>

					{{-- Payment info area: payments left, footer/barcodes right --}}
					<div class="a4-row a4-avoid">
						<div class="a4-col a4-50">
							@if(!empty($receipt_details->payments))
								<table class="table table-slim" style="width:90%;">
									@foreach($receipt_details->payments as $payment)
										<tr>
											<td>{{$payment['method']}}</td>
											<td>{{$payment['amount']}}</td>
											<td class="a4-right">{{$payment['date']}}</td>
										</tr>
									@endforeach
								</table>
							@endif

							<div class="a4-mt-12">
								<b>{{__('lang_v1.authorized_signatory')}}</b>
							</div>

							@if(!empty($receipt_details->footer_text))
								<div class="a4-mt-12">
									{!! $receipt_details->footer_text !!}
								</div>
							@endif
						</div>

						<div class="a4-col a4-50 a4-right">
                          @if($receipt_details->show_barcode || $receipt_details->show_qr_code)
                            <div class="a4-qr-box">
                              @if($receipt_details->show_barcode)
                                <div>
                                  <img src="data:image/png;base64,{{DNS1D::getBarcodePNG($receipt_details->invoice_no, 'C128', 2,30,array(39, 48, 54), true)}}">
                                </div>
                              @endif
                        
                              @if($receipt_details->show_qr_code && !empty($receipt_details->qr_code_text))
                                <div class="a4-qr-bottom">
                                  <img src="data:image/png;base64,{{DNS2D::getBarcodePNG($receipt_details->qr_code_text, 'QRCODE', 3, 3, [39, 48, 54])}}">
                                </div>
                              @endif
                            </div>
                          @endif
                        </div>
					</div>

				</div>

			</td>
		</tr>
	</tbody>
</table>
