<table style="width:100%; color:#000000 !important;">
	<tbody>
		<tr>
			<td>

				<style>
					@page { size: A4 portrait; margin: 12mm; }
					* { box-sizing: border-box; }
					.a4-wrap { width: 100%; font-family: Arial, Helvetica, sans-serif; }
					.a4-row { width: 100%; display: table; table-layout: fixed; }
					.a4-col { display: table-cell; vertical-align: top; }
					.a4-50 { width: 50%; }
					.a4-60 { width: 60%; }
					.a4-40 { width: 40%; }
					.a4-right { text-align: right; }
					.a4-muted { color: #666; }
					.a4-h1 { font-size: 18px; font-weight: 800; margin: 0; }
					.a4-h2 { font-size: 16px; font-weight: 800; margin: 0 0 10px; letter-spacing: .5px; }
					.a4-mt-12 { margin-top: 12px; }
					.a4-mt-18 { margin-top: 18px; }
					.a4-mt-24 { margin-top: 24px; }
					.a4-band {
						background: #b9e3d6 !important;
						border: 1px solid #9fd3c3;
						padding: 18px 18px 16px;
						-webkit-print-color-adjust: exact;
						print-color-adjust: exact;
					}
					.a4-kv { width: 100%; border-collapse: collapse; }
                    .a4-kv td { padding: 2px 0; vertical-align: top; }
                    
                    .a4-kv td.key{
                      width: 52%;
                      font-weight: 700;
                      text-align: right;     /* <-- puts "Invoice No:" near the value (right side) */
                      padding-right: 10px;   /* <-- spacing */
                      white-space: nowrap;
                    }
                    .a4-kv td.val{
                      width: 48%;
                      text-align: right;
                      white-space: nowrap;
                    }

					.a4-divider { border-top: 2px solid #7f7f7f; margin: 18px 0; }
					.a4-thanks { font-size: 24px; font-weight: 600; color: #666; line-height: 1.1; }
					.a4-avoid { page-break-inside: avoid !important; }
					
					.a4-items{
                      border-collapse: collapse !important;
                      border-spacing: 0 !important;
                    }
                    .a4-items.table-bordered,
                    .a4-items.table-bordered > thead > tr > th,
                    .a4-items.table-bordered > tbody > tr > td{
                      border: 1px solid #d0d0d0 !important; /* single consistent line */
                    }
                    
                    /* items table */
                    .a4-items{
                      border-collapse: collapse !important;
                      border-spacing: 0 !important;
                      border: 1px solid #d0d0d0 !important; /* outer border stays */
                    }
                    
                    /* normal grid */
                    .a4-items th,
                    .a4-items td{
                      border: 1px solid #d0d0d0 !important;
                    }
                    
                    /* EMPTY filler rows: remove grid lines */
                    .a4-items tr.a4-empty-row td{
                      border: 0 !important;              
                      height: 18px;                    
                    }
                    
                    .a4-qr-box{
                      position: relative;
                      min-height: 160px; /* increase if you want it lower */
                    }
                    .a4-qr-bottom{
                      position: absolute;
                      right: 0;
                      bottom: 2px;
                    }
				</style>

				<div class="a4-wrap">

					
					<div class="a4-band">
						<div class="a4-row">
							<div class="a4-col a4-60">
								<?php
                                  $display_name_first = '';
                                  if (!empty($receipt_details->display_name)) {
                                      $parts = explode(',', $receipt_details->display_name);
                                      $display_name_first = trim($parts[0] ?? $receipt_details->display_name);
                                  }
                                ?>
                                
                                <?php if(!empty($display_name_first)): ?>
                                  <div class="a4-h1"><?php echo e($display_name_first, false); ?></div>
                                <?php endif; ?>

								<div class="a4-muted a4-mt-12" style="line-height: 1.5;">
									<?php if(!empty($receipt_details->address)): ?>
										<?php echo $receipt_details->address; ?><br>
									<?php endif; ?>
									<?php if(!empty($receipt_details->contact)): ?>
										<?php echo $receipt_details->contact; ?><br>
									<?php endif; ?>
									<?php if(!empty($receipt_details->website)): ?>
										<?php echo e($receipt_details->website, false); ?><br>
									<?php endif; ?>
									<?php if(!empty($receipt_details->tax_info1)): ?>
										<?php echo e($receipt_details->tax_label1, false); ?> <?php echo e($receipt_details->tax_info1, false); ?><br>
									<?php endif; ?>
									<?php if(!empty($receipt_details->tax_info2)): ?>
										<?php echo e($receipt_details->tax_label2, false); ?> <?php echo e($receipt_details->tax_info2, false); ?><br>
									<?php endif; ?>
									<?php if(!empty($receipt_details->location_custom_fields)): ?>
										<?php echo e($receipt_details->location_custom_fields, false); ?>

									<?php endif; ?>
								</div>

								<?php if(!empty($receipt_details->invoice_heading)): ?>
									<div class="a4-mt-18" style="font-weight: 800; font-size: 22px;">
										<?php echo $receipt_details->invoice_heading; ?>

									</div>
								<?php endif; ?>
							</div>

							<div class="a4-col a4-40 a4-right">
                              <?php if(empty($receipt_details->letter_head)): ?>
                                <?php if(!empty($receipt_details->logo)): ?>
                                  <img
                                    src="<?php echo e($receipt_details->logo, false); ?>"
                                    style="
                                      max-height: 80px;      /* smaller logo */
                                      width: auto;
                                      float: right;         /* push to the extreme right */
                                      display: block;
                                    "
                                  >
                                <?php endif; ?>
                              <?php endif; ?>
                            </div>
						</div>
					</div>

					<?php if(!empty($receipt_details->letter_head)): ?>
						<div class="a4-mt-12">
							<img style="width: 100%; margin-bottom: 10px;" src="<?php echo e($receipt_details->letter_head, false); ?>">
						</div>
					<?php endif; ?>

					
					<div class="a4-row a4-mt-24">
						<div class="a4-col a4-50">
							<div class="a4-h2"><?php echo e(__('BILL TO'), false); ?></div>

							<div style="line-height: 1.5;">
								<?php if(!empty($receipt_details->customer_label)): ?>
									<strong><?php echo e($receipt_details->customer_label, false); ?></strong><br>
								<?php endif; ?>

								<?php if(!empty($receipt_details->customer_info)): ?>
									<?php echo $receipt_details->customer_info; ?>

								<?php endif; ?>

								<?php if(!empty($receipt_details->client_id_label)): ?>
									<br><strong><?php echo e($receipt_details->client_id_label, false); ?></strong> <?php echo e($receipt_details->client_id, false); ?>

								<?php endif; ?>

								<?php if(!empty($receipt_details->customer_tax_label)): ?>
									<br><strong><?php echo e($receipt_details->customer_tax_label, false); ?></strong> <?php echo e($receipt_details->customer_tax_number, false); ?>

								<?php endif; ?>

								<?php if(!empty($receipt_details->customer_custom_fields)): ?>
									<br><?php echo $receipt_details->customer_custom_fields; ?>

								<?php endif; ?>

								<?php if(!empty($receipt_details->sales_person_label)): ?>
									<br><strong><?php echo e($receipt_details->sales_person_label, false); ?></strong> <?php echo e($receipt_details->sales_person, false); ?>

								<?php endif; ?>

								<?php if(!empty($receipt_details->commission_agent_label)): ?>
									<br><strong><?php echo e($receipt_details->commission_agent_label, false); ?></strong> <?php echo e($receipt_details->commission_agent, false); ?>

								<?php endif; ?>

								<?php if(!empty($receipt_details->customer_rp_label)): ?>
									<br><strong><?php echo e($receipt_details->customer_rp_label, false); ?></strong> <?php echo e($receipt_details->customer_total_rp, false); ?>

								<?php endif; ?>

								<?php if(!empty($receipt_details->types_of_service)): ?>
									<br>
									<strong><?php echo $receipt_details->types_of_service_label; ?>:</strong> <?php echo e($receipt_details->types_of_service, false); ?>

									<?php if(!empty($receipt_details->types_of_service_custom_fields)): ?>
										<br>
										<?php $__currentLoopData = $receipt_details->types_of_service_custom_fields; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
											<strong><?php echo e($key, false); ?>:</strong> <?php echo e($value, false); ?><?php if(!$loop->last): ?>, <?php endif; ?>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
									<?php endif; ?>
								<?php endif; ?>
							</div>
						</div>

						<div class="a4-col a4-50">
							<div class="a4-h2 a4-right"><?php echo e(__('INVOICE DETAILS'), false); ?></div>

							<table class="a4-kv">
								<?php if(!empty($receipt_details->invoice_no_prefix) || !empty($receipt_details->invoice_no)): ?>
									<tr>
                                      <td class="key">
                                        <?php echo !empty($receipt_details->invoice_no_prefix) ? $receipt_details->invoice_no_prefix : __('Invoice No:'); ?>

                                      </td>
                                      <td class="val">
                                        <?php echo e($receipt_details->invoice_no, false); ?>

                                      </td>
                                    </tr>
								<?php endif; ?>

								<?php if(!empty($receipt_details->date_label)): ?>
									<tr>
										<td class="key a4-right"><?php echo e($receipt_details->date_label, false); ?></td>
										<td class="val"><?php echo e($receipt_details->invoice_date, false); ?></td>
									</tr>
								<?php endif; ?>

								<?php if(!empty($receipt_details->due_date_label)): ?>
									<tr>
										<td class="key a4-right"><?php echo e($receipt_details->due_date_label, false); ?></td>
										<td class="val"><?php echo e($receipt_details->due_date ?? '', false); ?></td>
									</tr>
								<?php endif; ?>

								<?php if(!empty($receipt_details->sell_custom_field_1_value)): ?>
									<tr>
										<td class="key a4-right"><?php echo e($receipt_details->sell_custom_field_1_label, false); ?></td>
										<td class="val"><?php echo e($receipt_details->sell_custom_field_1_value, false); ?></td>
									</tr>
								<?php endif; ?>
								<?php if(!empty($receipt_details->sell_custom_field_2_value)): ?>
									<tr>
										<td class="key a4-right"><?php echo e($receipt_details->sell_custom_field_2_label, false); ?></td>
										<td class="val"><?php echo e($receipt_details->sell_custom_field_2_value, false); ?></td>
									</tr>
								<?php endif; ?>
								<?php if(!empty($receipt_details->sell_custom_field_3_value)): ?>
									<tr>
										<td class="key a4-right"><?php echo e($receipt_details->sell_custom_field_3_label, false); ?></td>
										<td class="val"><?php echo e($receipt_details->sell_custom_field_3_value, false); ?></td>
									</tr>
								<?php endif; ?>
								<?php if(!empty($receipt_details->sell_custom_field_4_value)): ?>
									<tr>
										<td class="key a4-right"><?php echo e($receipt_details->sell_custom_field_4_label, false); ?></td>
										<td class="val"><?php echo e($receipt_details->sell_custom_field_4_value, false); ?></td>
									</tr>
								<?php endif; ?>

								<?php if(!empty($receipt_details->total_due) && !empty($receipt_details->total_due_label)): ?>
									<tr>
										<td class="key a4-right"><?php echo $receipt_details->total_due_label; ?></td>
										<td class="val"><?php echo e($receipt_details->total_due, false); ?></td>
									</tr>
								<?php endif; ?>

								<?php if(!empty($receipt_details->total_previous_due)): ?>
									<tr>
										<td class="key a4-right"><?php echo $receipt_details->total_previous_due_label; ?></td>
										<td class="val"><?php echo e($receipt_details->total_previous_due, false); ?></td>
									</tr>
								<?php endif; ?>

								<?php if(!empty($receipt_details->all_due)): ?>
									<tr>
										<td class="key a4-right"><?php echo $receipt_details->all_bal_label; ?></td>
										<td class="val"><?php echo e($receipt_details->all_due, false); ?></td>
									</tr>
								<?php endif; ?>

								<?php if(!empty($receipt_details->total_paid)): ?>
									<tr>
										<td class="key a4-right"><?php echo $receipt_details->total_paid_label; ?></td>
										<td class="val"><?php echo e($receipt_details->total_paid, false); ?></td>
									</tr>
								<?php endif; ?>
							</table>

							<?php if(!empty($receipt_details->table_label) || !empty($receipt_details->table)): ?>
								<div class="a4-mt-12 a4-right">
									<?php if(!empty($receipt_details->table_label)): ?>
										<?php echo $receipt_details->table_label; ?>

									<?php endif; ?>
									<?php echo e($receipt_details->table, false); ?>

								</div>
							<?php endif; ?>

							<?php if(!empty($receipt_details->service_staff_label) || !empty($receipt_details->service_staff)): ?>
								<div class="a4-right">
									<?php if(!empty($receipt_details->service_staff_label)): ?>
										<?php echo $receipt_details->service_staff_label; ?>

									<?php endif; ?>
									<?php echo e($receipt_details->service_staff, false); ?>

								</div>
							<?php endif; ?>
						</div>
					</div>

					
					<?php if(!empty($receipt_details->shipping_custom_field_1_label) || !empty($receipt_details->shipping_custom_field_2_label)): ?>
						<div class="a4-row a4-mt-12">
							<div class="a4-col a4-50">
								<?php if(!empty($receipt_details->shipping_custom_field_1_label)): ?>
									<strong><?php echo $receipt_details->shipping_custom_field_1_label; ?> :</strong> <?php echo $receipt_details->shipping_custom_field_1_value ?? ''; ?>

								<?php endif; ?>
							</div>
							<div class="a4-col a4-50 a4-right">
								<?php if(!empty($receipt_details->shipping_custom_field_2_label)): ?>
									<strong><?php echo $receipt_details->shipping_custom_field_2_label; ?> :</strong> <?php echo $receipt_details->shipping_custom_field_2_value ?? ''; ?>

								<?php endif; ?>
							</div>
						</div>
					<?php endif; ?>

					<?php if(!empty($receipt_details->shipping_custom_field_3_label) || !empty($receipt_details->shipping_custom_field_4_label)): ?>
						<div class="a4-row a4-mt-12">
							<div class="a4-col a4-50">
								<?php if(!empty($receipt_details->shipping_custom_field_3_label)): ?>
									<strong><?php echo $receipt_details->shipping_custom_field_3_label; ?> :</strong> <?php echo $receipt_details->shipping_custom_field_3_value ?? ''; ?>

								<?php endif; ?>
							</div>
							<div class="a4-col a4-50 a4-right">
								<?php if(!empty($receipt_details->shipping_custom_field_4_label)): ?>
									<strong><?php echo $receipt_details->shipping_custom_field_4_label; ?> :</strong> <?php echo $receipt_details->shipping_custom_field_4_value ?? ''; ?>

								<?php endif; ?>
							</div>
						</div>
					<?php endif; ?>

					<?php if(!empty($receipt_details->shipping_custom_field_5_label)): ?>
						<div class="a4-row a4-mt-12">
							<div class="a4-col a4-50">
								<strong><?php echo $receipt_details->shipping_custom_field_5_label; ?> :</strong> <?php echo $receipt_details->shipping_custom_field_5_value ?? ''; ?>

							</div>
						</div>
					<?php endif; ?>

					<?php if(!empty($receipt_details->sale_orders_invoice_no) || !empty($receipt_details->sale_orders_invoice_date)): ?>
						<div class="a4-row a4-mt-12">
							<div class="a4-col a4-50">
								<strong><?php echo app('translator')->get('restaurant.order_no'); ?>:</strong> <?php echo $receipt_details->sale_orders_invoice_no ?? ''; ?>

							</div>
							<div class="a4-col a4-50 a4-right">
								<strong><?php echo app('translator')->get('lang_v1.order_dates'); ?>:</strong> <?php echo $receipt_details->sale_orders_invoice_date ?? ''; ?>

							</div>
						</div>
					<?php endif; ?>

					<div class="a4-row a4-mt-12">
						<?php if ($__env->exists('sale_pos.receipts.partial.common_repair_invoice')) echo $__env->make('sale_pos.receipts.partial.common_repair_invoice', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
					</div>

					
					<div class="a4-mt-24">
						<table class="table table-bordered table-no-top-cell-border table-slim mb-12 a4-items" style="width:100%;">
							
                            <?php
                              $merge_cat_into_product = ($receipt_details->show_cat_code == 1);
                              $product_colspan = $merge_cat_into_product ? 2 : 1;
                            
                              $p_width = 40;
                              if ($merge_cat_into_product) {
                                $p_width += 10; // take the removed cat-code width
                              }
                              if(!empty($receipt_details->item_discount_label)) $p_width -= 10;
                              if(!empty($receipt_details->discounted_unit_price_label)) $p_width -= 5;
                            ?>
                            
                            <thead>
                              <tr style="background-color:#357ca5 !important;color:#fff !important;font-size:20px !important"
                                  class="table-no-side-cell-border table-no-top-cell-border text-center">
                                <td style="background-color:#357ca5 !important;color:#fff !important;width:5% !important">#</td>
                            
                                <td colspan="<?php echo e($product_colspan, false); ?>"
                                    style="background-color:#357ca5 !important;color:#fff !important;width:<?php echo e($p_width, false); ?>% !important">
                                  <?php echo e($receipt_details->table_product_label, false); ?>

                                </td>
                            
                                <td style="background-color:#357ca5 !important;color:#fff !important;width:15% !important;">
                                  <?php echo e($receipt_details->table_qty_label, false); ?>

                                </td>
                                <td style="background-color:#357ca5 !important;color:#fff !important;width:15% !important;">
                                  <?php echo e($receipt_details->table_unit_price_label, false); ?>

                                </td>
                            
                                <?php if(!empty($receipt_details->discounted_unit_price_label)): ?>
                                  <td style="background-color:#357ca5 !important;color:#fff !important;width:10% !important;">
                                    <?php echo e($receipt_details->discounted_unit_price_label, false); ?>

                                  </td>
                                <?php endif; ?>
                            
                                <?php if(!empty($receipt_details->item_discount_label)): ?>
                                  <td style="background-color:#357ca5 !important;color:#fff !important;width:10% !important;">
                                    <?php echo e($receipt_details->item_discount_label, false); ?>

                                  </td>
                                <?php endif; ?>
                            
                                <td style="background-color:#357ca5 !important;color:#fff !important;width:10% !important;">
                                  <?php echo e($receipt_details->table_subtotal_label, false); ?>

                                </td>
                              </tr>
                            </thead>
                            
                            
                            <tbody>
                            <?php $__currentLoopData = $receipt_details->lines; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $line): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                              <tr>
                                <td class="text-center"><?php echo e($loop->iteration, false); ?></td>
                            
                                <td colspan="<?php echo e($product_colspan, false); ?>">
                                  <?php if(!empty($line['image'])): ?>
                                    <img src="<?php echo e($line['image'], false); ?>" alt="Image" width="50" style="float:left;margin-right:8px;">
                                  <?php endif; ?>
                            
                                  <?php echo e($line['name'], false); ?> <?php echo e($line['product_variation'], false); ?> <?php echo e($line['variation'], false); ?>

                                  <?php if(!empty($line['sub_sku'])): ?>, <?php echo e($line['sub_sku'], false); ?> <?php endif; ?>
                                  <?php if(!empty($line['brand'])): ?>, <?php echo e($line['brand'], false); ?> <?php endif; ?>
                                  <?php if(!empty($line['product_custom_fields'])): ?>, <?php echo e($line['product_custom_fields'], false); ?> <?php endif; ?>
                            
                                  
                                  <?php if($merge_cat_into_product && !empty($line['cat_code'])): ?>
                                    , <?php echo e($line['cat_code'], false); ?>

                                  <?php endif; ?>
                            
                                  <?php if(!empty($line['product_description'])): ?>
                                    <small><?php echo $line['product_description']; ?></small>
                                  <?php endif; ?>
                            
                                  <?php if(!empty($line['sell_line_note'])): ?>
                                    <br><small><?php echo $line['sell_line_note']; ?></small>
                                  <?php endif; ?>
                            
                                  <?php if(!empty($line['lot_number'])): ?><br> <?php echo e($line['lot_number_label'], false); ?>: <?php echo e($line['lot_number'], false); ?> <?php endif; ?>
                                  <?php if(!empty($line['product_expiry'])): ?>, <?php echo e($line['product_expiry_label'], false); ?>: <?php echo e($line['product_expiry'], false); ?> <?php endif; ?>
                                </td>
                            
                                <td class="text-right"><?php echo e($line['quantity'], false); ?> <?php echo e($line['units'], false); ?></td>
                                <td class="text-right"><?php echo e($line['unit_price_before_discount'], false); ?></td>
                            
                                <?php if(!empty($receipt_details->discounted_unit_price_label)): ?>
                                  <td class="text-right"><?php echo e($line['unit_price_inc_tax'], false); ?></td>
                                <?php endif; ?>
                            
                                <?php if(!empty($receipt_details->item_discount_label)): ?>
                                  <td class="text-right">
                                    <?php echo e($line['total_line_discount'] ?? '0.00', false); ?>

                                    <?php if(!empty($line['line_discount_percent'])): ?> (<?php echo e($line['line_discount_percent'], false); ?>%) <?php endif; ?>
                                  </td>
                                <?php endif; ?>
                            
                                <td class="text-right"><?php echo e($line['line_total_exc_tax'], false); ?></td>
                              </tr>
                            
                              
                              <?php if(!empty($line['modifiers'])): ?>
                                <?php $__currentLoopData = $line['modifiers']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $modifier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                  <tr>
                                    <td class="text-center">&nbsp;</td>
                            
                                    <td colspan="<?php echo e($product_colspan, false); ?>">
                                      <?php echo e($modifier['name'], false); ?> <?php echo e($modifier['variation'], false); ?>

                                      <?php if(!empty($modifier['sub_sku'])): ?>, <?php echo e($modifier['sub_sku'], false); ?> <?php endif; ?>
                                      <?php if(!empty($modifier['sell_line_note'])): ?>(<?php echo $modifier['sell_line_note']; ?>) <?php endif; ?>
                            
                                      <?php if($merge_cat_into_product && !empty($modifier['cat_code'])): ?>
                                        , <?php echo e($modifier['cat_code'], false); ?>

                                      <?php endif; ?>
                                    </td>
                            
                                    <td class="text-right"><?php echo e($modifier['quantity'], false); ?> <?php echo e($modifier['units'], false); ?></td>
                                    <td class="text-right"><?php echo e($modifier['unit_price_exc_tax'], false); ?></td>
                            
                                    <?php if(!empty($receipt_details->discounted_unit_price_label)): ?>
                                      <td class="text-right"><?php echo e($modifier['unit_price_exc_tax'], false); ?></td>
                                    <?php endif; ?>
                                    <?php if(!empty($receipt_details->item_discount_label)): ?>
                                      <td class="text-right">0.00</td>
                                    <?php endif; ?>
                            
                                    <td class="text-right"><?php echo e($modifier['line_total'], false); ?></td>
                                  </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                              <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            
                            
                            <?php
                              $rowCount = count($receipt_details->lines ?? []);
                              $minRows = 7;
                            
                              $cols = 1 /* # */ + 1 /* Product (merged) */ + 1 /* Qty */ + 1 /* Unit Price */ + 1 /* Subtotal */;
                              if(!empty($receipt_details->discounted_unit_price_label)) $cols++;
                              if(!empty($receipt_details->item_discount_label)) $cols++;
                            ?>
                            
                            <?php for($r = $rowCount; $r < $minRows; $r++): ?>
                              <tr class="a4-empty-row">
                                <?php for($c = 0; $c < $cols; $c++): ?>
                                  <td>&nbsp;</td>
                                <?php endfor; ?>
                              </tr>
                            <?php endfor; ?>
                            </tbody>
						</table>
					</div>

					
					<div class="a4-row a4-mt-24 a4-avoid">
						<div class="a4-col a4-50">
							<div class="a4-thanks">
								Thank you for your<br>business!
							</div>

							<?php if(!empty($receipt_details->additional_notes)): ?>
								<div class="a4-mt-18"><?php echo nl2br($receipt_details->additional_notes); ?></div>
							<?php endif; ?>
						</div>

						<div class="a4-col a4-50">
							<table class="table-no-side-cell-border table-no-top-cell-border width-100 table-slim">
								<tbody>
									<?php if(!empty($receipt_details->total_quantity_label)): ?>
										<tr>
											<td style="width:50%"><?php echo $receipt_details->total_quantity_label; ?></td>
											<td class="text-right"><?php echo e($receipt_details->total_quantity, false); ?></td>
										</tr>
									<?php endif; ?>

									<?php if(!empty($receipt_details->total_items_label)): ?>
										<tr>
											<td style="width:50%"><?php echo $receipt_details->total_items_label; ?></td>
											<td class="text-right"><?php echo e($receipt_details->total_items, false); ?></td>
										</tr>
									<?php endif; ?>

									<tr>
										<td style="width:50%"><?php echo $receipt_details->subtotal_label; ?></td>
										<td class="text-right"><?php echo e($receipt_details->subtotal_exc_tax, false); ?></td>
									</tr>

									<?php if(!empty($receipt_details->shipping_charges)): ?>
										<tr>
											<td style="width:50%"><?php echo $receipt_details->shipping_charges_label; ?></td>
											<td class="text-right"><?php echo e($receipt_details->shipping_charges, false); ?></td>
										</tr>
									<?php endif; ?>

									<?php if(!empty($receipt_details->packing_charge)): ?>
										<tr>
											<td style="width:50%"><?php echo $receipt_details->packing_charge_label; ?></td>
											<td class="text-right"><?php echo e($receipt_details->packing_charge, false); ?></td>
										</tr>
									<?php endif; ?>

									<?php if(!empty($receipt_details->taxes)): ?>
										<?php $__currentLoopData = $receipt_details->taxes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
											<tr>
												<td><?php echo e($k, false); ?></td>
												<td class="text-right">(+) <?php echo e($v, false); ?></td>
											</tr>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
									<?php endif; ?>

									<?php if(!empty($receipt_details->discount)): ?>
										<tr>
											<td><?php echo $receipt_details->discount_label; ?></td>
											<td class="text-right">(-) <?php echo e($receipt_details->discount, false); ?></td>
										</tr>
									<?php endif; ?>

									<?php if(!empty($receipt_details->total_line_discount)): ?>
										<tr>
											<td><?php echo $receipt_details->line_discount_label; ?></td>
											<td class="text-right">(-) <?php echo e($receipt_details->total_line_discount, false); ?></td>
										</tr>
									<?php endif; ?>

									<?php if(!empty($receipt_details->additional_expenses)): ?>
										<?php $__currentLoopData = $receipt_details->additional_expenses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
											<tr>
												<td><?php echo e($key, false); ?>:</td>
												<td class="text-right">(+) <?php echo e($val, false); ?></td>
											</tr>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
									<?php endif; ?>

									<?php if(!empty($receipt_details->reward_point_label)): ?>
										<tr>
											<td><?php echo $receipt_details->reward_point_label; ?></td>
											<td class="text-right">(-) <?php echo e($receipt_details->reward_point_amount, false); ?></td>
										</tr>
									<?php endif; ?>

									<?php if(!empty($receipt_details->group_tax_details)): ?>
										<?php $__currentLoopData = $receipt_details->group_tax_details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
											<tr>
												<td><?php echo $key; ?></td>
												<td class="text-right">(+) <?php echo e($value, false); ?></td>
											</tr>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
									<?php else: ?>
										<?php if(!empty($receipt_details->tax)): ?>
											<tr>
												<td><?php echo $receipt_details->tax_label; ?></td>
												<td class="text-right">(+) <?php echo e($receipt_details->tax, false); ?></td>
											</tr>
										<?php endif; ?>
									<?php endif; ?>

									<?php if($receipt_details->round_off_amount > 0): ?>
										<tr>
											<td><?php echo $receipt_details->round_off_label; ?></td>
											<td class="text-right"><?php echo e($receipt_details->round_off, false); ?></td>
										</tr>
									<?php endif; ?>

									<tr>
										<th style="background-color: #357ca5 !important; color: white !important" class="font-23 padding-10">
											<?php echo $receipt_details->total_label; ?>

										</th>
										<td class="text-right font-23 padding-10" style="background-color: #357ca5 !important; color: white !important">
											<?php echo e($receipt_details->total, false); ?>

										</td>
									</tr>

									<?php if(!empty($receipt_details->total_in_words)): ?>
										<tr>
											<td colspan="2" class="text-right">
												<small>(<?php echo e($receipt_details->total_in_words, false); ?>)</small>
											</td>
										</tr>
									<?php endif; ?>
								</tbody>
							</table>
						</div>
					</div>

					
					<div class="a4-mt-18">
						<?php if(empty($receipt_details->hide_price) && !empty($receipt_details->tax_summary_label)): ?>
							<?php if(!empty($receipt_details->taxes)): ?>
								<table class="table table-slim table-bordered" style="width:100%;">
									<tr>
										<th colspan="2" class="text-center"><?php echo e($receipt_details->tax_summary_label, false); ?></th>
									</tr>
									<?php $__currentLoopData = $receipt_details->taxes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
										<tr>
											<td class="text-center"><b><?php echo e($key, false); ?></b></td>
											<td class="text-center"><?php echo e($val, false); ?></td>
										</tr>
									<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
								</table>
							<?php endif; ?>
						<?php endif; ?>
					</div>

					<div class="a4-divider"></div>

					
					<div class="a4-row a4-avoid">
						<div class="a4-col a4-50">
							<?php if(!empty($receipt_details->payments)): ?>
								<table class="table table-slim" style="width:90%;">
									<?php $__currentLoopData = $receipt_details->payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
										<tr>
											<td><?php echo e($payment['method'], false); ?></td>
											<td><?php echo e($payment['amount'], false); ?></td>
											<td class="a4-right"><?php echo e($payment['date'], false); ?></td>
										</tr>
									<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
								</table>
							<?php endif; ?>

							<div class="a4-mt-12">
								<b><?php echo e(__('lang_v1.authorized_signatory'), false); ?></b>
							</div>

							<?php if(!empty($receipt_details->footer_text)): ?>
								<div class="a4-mt-12">
									<?php echo $receipt_details->footer_text; ?>

								</div>
							<?php endif; ?>
						</div>

						<div class="a4-col a4-50 a4-right">
                          <?php if($receipt_details->show_barcode || $receipt_details->show_qr_code): ?>
                            <div class="a4-qr-box">
                              <?php if($receipt_details->show_barcode): ?>
                                <div>
                                  <img src="data:image/png;base64,<?php echo e(DNS1D::getBarcodePNG($receipt_details->invoice_no, 'C128', 2,30,array(39, 48, 54), true), false); ?>">
                                </div>
                              <?php endif; ?>
                        
                              <?php if($receipt_details->show_qr_code && !empty($receipt_details->qr_code_text)): ?>
                                <div class="a4-qr-bottom">
                                  <img src="data:image/png;base64,<?php echo e(DNS2D::getBarcodePNG($receipt_details->qr_code_text, 'QRCODE', 3, 3, [39, 48, 54]), false); ?>">
                                </div>
                              <?php endif; ?>
                            </div>
                          <?php endif; ?>
                        </div>
					</div>

				</div>

			</td>
		</tr>
	</tbody>
</table>
<?php /**PATH /home/parawfza/datagh.online/resources/views/sale_pos/receipts/elegant.blade.php ENDPATH**/ ?>